define([
    'jquery',
    'underscore',
    'Magento_Swatches/js/swatch-renderer'
], function ($, _) {
    'use strict';

    $.widget('mageants.AbSwatchRenderer', $.mage.SwatchRenderer, {
        _create: function () {
            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');
        },

        _RenderFormInput: function (config) {
            var productId = this.options.jsonConfig.productId,
                inputHtml = this._super(config);

            inputHtml = inputHtml.replace('super_attribute', 'super_attribute[' + productId + ']');

            return inputHtml;
        },

        _OnClick: function ($this, $widget) {
            this._super($this, $widget);

            if ($widget.element.closest('.mageants-ab-item').find('.item-price').length) {
                this._UpdatePrice($widget);

            }
        },

    _UpdatePrice: function ($widget) {
        var $product = $widget.element.closest('.mageants-ab-item'),
            options = _.object(_.keys($widget.optionsMap), {}),
            result;

        // Check for Magento 2.4 or higher
        if ($widget.element.find('[data-option-selected]').length) {
            $widget.element.find('[data-option-selected]').each(function () {
                var attributeId = $(this).attr('data-attribute-id');
                var optionValue = $(this).attr('data-option-selected');
                options[attributeId] = optionValue;
            });
        }

        // For Magento 2.3
        if ($widget.element.find('[option-selected]').length) {
            $widget.element.find('[option-selected]').each(function () {
                var attributeId = $(this).attr('attribute-id');
                var optionValue = $(this).attr('option-selected');
                options[attributeId] = optionValue;
            });
        }

        var optionKey = _.findKey($widget.options.jsonConfig.index, options);
       
        result = $widget.options.jsonConfig.optionPrices[optionKey];

        var priceFormat = $widget.options.jsonConfig.priceFormat.pattern;

            if (result) {
                var formattedPrice = parseFloat(result.finalPrice.amount).toFixed(2);

                formattedPrice = priceFormat.replace('%s', '') + formattedPrice;
            
                $product.find('.item-price').html(
                    '<strong>' + formattedPrice + '</strong>'
                );
            }
        }
    });

    return $.mageants.AbSwatchRenderer;
});
